---
category: reference
heading: "add(document, value)"
---

Takes a JSON document and a value and adds the value into
the doc at the position pointed to. If the position pointed to is
in an array then the existing element at that position (if any)
and all that follow it have there position incremented to make
room. It is an error to add to a parent object that doesn't exist
or to try to replace an existing value in an object.

* document - The document to operate against. 
* value - The value to insert at the position pointed to

Example:

    var doc = new JSONPointer("/obj/new").add({obj:   {old:"hello"}},"world");
    // doc now equals {obj: {old: "hello", new: "world"}}

Returns the updated doc.

